#include <cstdio>
#include <iostream>
#include <string>
#include <vector>
#include <algorithm>
#include <cmath>
#include <cassert>
#include <memory.h>
#include <queue>
#include <deque>
#include <stack>
#include <list>
#include <map>
#include <set>
#include <functional>
#include <cstring>
#include <ctime>

using namespace std;

#define all(a) a.begin(), a.end()
#define mp make_pair

typedef long long li;
typedef long double ld;
typedef pair<int, int> pi;
typedef vector<int> vi;

#define FILENAME ""

void prec();
void solve();

int main() {
#ifdef YA
	string s = FILENAME;
	//assert(!s.empty());
	clock_t start = clock();
	freopen("input.txt", "r", stdin);
	//freopen("output.txt", "w", stdout);
#else
	//freopen(FILENAME ".in", "r", stdin);
	//freopen(FILENAME ".out", "w", stdout);
	//freopen("input.txt", "r", stdin);
	//freopen("output.txt", "w", stdout);
#endif
	cout.sync_with_stdio(0);
	cin.tie(0);
	cout.precision(15);
	cout << fixed;

	int t = 1;
	//cin >> t;
	prec();
	while(true) {
		solve();
	}
#ifdef YA
	cout << "\n\n" << (clock() - start) / 1.0 / CLOCKS_PER_SEC << "\n\n";
#endif
	return 0;
}


//#define int li




int MYPREC[1024 * 16 + 100];

void prec() {
	int tmpp = 10 + 3;

	int m = 1024 * 16;

	MYPREC[m] = tmpp;

	for (int i = m - 1; i >= 0; --i) {
		while ((1 << tmpp) > i) {
			--tmpp;
		}
		if ((1 << (tmpp + 1)) - 1 == i)
			MYPREC[i] = tmpp;
		else
			MYPREC[i] = tmpp - 1;
	}
	MYPREC[1] = 0;
}


int TIMER = 1;



struct elem {
	int pr;
	int t;
	elem():pr(0), t(0){}
	elem(int pr, int t):pr(pr),t(t){}
};

int n, m, T;
vector <vector <int> > g;
vector <vector <int> > grev;
vector <int> order;
vector <int> used;
vector <int> color;
vector <int> compSize;
vector < vector < elem > > elements;
vector < vector <int> > compG;
int numColor;

void dfs1(int v) {
	used[v] = TIMER;

	for (int i = 0; i < g[v].size(); ++i) {
		int to = g[v][i];
		if (used[to] != TIMER) {
			dfs1(to);
		}
	}

	order.push_back(v);
}

void dfs2(int v) {
	used[v] = TIMER;

	for (int i = 0; i < grev[v].size(); ++i) {
		int to = grev[v][i];
		if (used[to] != TIMER) {
			color[to] = color[v];
			dfs2(to);
		}
	}

	//order.push_back(v);
}


void dfscompG(int v) {
	used[v] = TIMER;

	for (int i = 0; i < compG[v].size(); ++i) {
		int to = compG[v][i];
		if (used[to] != TIMER) {
			dfscompG(to);
		}
	}

	order.push_back(v);
}

vector < vector <int> > dp;

void initDp() {
	
	dp.assign(numColor, vector <int> (T + 1, 0));

}

void goDp(int v) {
	for (int i = 0; i < elements[v].size(); ++i) {
		for (int time = T - elements[v][i].t; time >= 0; --time) {
			dp[v][time + elements[v][i].t] = max(dp[v][time + elements[v][i].t], dp[v][time] + elements[v][i].pr);
		}
	}

	for (int i = 0; i < compG[v].size(); ++i) {
		int to = compG[v][i];
		for (int time = 0; time <= T; ++time) {
			dp[to][time] = max(dp[to][time], dp[v][time]);
		}
	}
}

vector <int> loop;

void solve() {
	loop.clear();
	elements.clear();
	grev.clear();
	g.clear();
	order.clear();
	used.clear();
	color.clear();
	compSize.clear();

	cin >> n >> m >> T;

	if (n == 0) {
		exit(0);
	}
	
	g.resize(n);
	loop.resize(n);
	grev.resize(n);
	used.resize(n);
	color.assign(n, -1);


	vector <int> pi, ti, ki;
	//read adverts
	pi.resize(n);
	ti.resize(n);
	ki.resize(n);
	for (int i = 0; i < n; ++i) {
		cin >> pi[i] >> ti[i] >> ki[i];
	}
	//end


	for (int i = 0; i < m; ++i) {
		int x, y;
		cin >> x >> y;
		--x;
		--y;
		if (x == y) {
			loop[x] = 1;
		}
		g[x].push_back(y);
		grev[y].push_back(x);
	}

	for (int i = 0; i < n; ++i) {
		if (used[i] != TIMER) {
			dfs1(i);
		}
	}
	reverse(order.begin(), order.end());

	++TIMER;
	numColor = 0;

	for (int i = 0; i < n; ++i) {
		int v = order[i];
		if (color[v] == -1) {
			color[v] = numColor;
			dfs2(v);
			++numColor;
		}
	}

	
	compSize.resize(numColor);
	elements.resize(numColor);
	
	for (int i = 0; i < n; ++i) {
		++compSize[color[i]];
	}
	
	for (int i = 0; i < n; ++i) {
		if (compSize[color[i]] == 1 && !loop[i]) {
			ki[i] = 1;
		}

		while (ki[i]) {

			int ttt = MYPREC[ki[i]];

			if (li(1 << ttt) * ti[i] <= T) {
				elements[color[i]].push_back(elem((1 << ttt) * pi[i], (1 << ttt) * ti[i]));
			}

			ki[i] -= (1 << ttt);
		}
	}

	
	compG.clear();
	compG.resize(numColor);

	for (int i = 0; i < n; ++i) {
		for (int j = 0; j < g[i].size(); ++j) {
			
			if (color[i] != color[g[i][j]]) {
				compG[color[i]].push_back(color[g[i][j]]);
			}
		}
	}

	for (int i = 0; i < numColor; ++i) {
		sort(compG[i].begin(), compG[i].end());
		compG[i].erase(unique(compG[i].begin(), compG[i].end()), compG[i].end());
	}

	
	order.clear();
	++TIMER;
	for (int i = 0; i < numColor; ++i) {
		if (used[i] != TIMER) {
			dfscompG(i);
		}
	}

	initDp();
	for (int i = 0; i < numColor; ++i) {
		int v = order[numColor - 1 - i];
		goDp(i);
	}

	int ans = 0;
	for (int i = 0; i < numColor; ++i) {
		for (int time = 0; time <= T; ++time) {
			if (ans < dp[i][time]) {
				ans = dp[i][time];
			}
		}
	}

	cout << ans << "\n";
}